/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  main.c
//  2KW Battery Charger: board REVISION C

//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//  
//  Built with Code Composer Studio Core Edition Version: 7.4.0.00015
//
//	Device: MPS430F2252
//
//******************************************************************************


#include "main.h"



// used for delay
unsigned int i_delay=0;
unsigned int number_of_slave=1;
// global variables for scheduler
//static volatile unsigned int counter_status_up=0;	// used for timing the change of the status going up
//static volatile unsigned int counter_status_down=0;	// used for timing the change of the status going down
volatile signed int counter_status=0;	// used for timing the change of the status
volatile unsigned int flag_1ms=1;		// used for 1ms timing
static volatile unsigned int counter_1ms=0;	// used for 1ms timing
static volatile unsigned int flag_10ms=1;				// used for 10ms timing
static volatile unsigned int counter_10ms=0;	// used for 10ms timing
static volatile unsigned int flag_50ms=1;		// used for 50ms timing
static volatile unsigned int counter_50ms=0;	// used for 50ms timing
static volatile unsigned int flag_100ms=1;		// used for 100ms timing
static volatile unsigned int counter_500ms=0;	// used for 500ms timing
static volatile unsigned int counter_5s=0;		// used for 5s timing
static volatile unsigned int flag_5s=0;			// used for 5s timing

volatile unsigned int Fan_speed = 0;			// used for measuring Fan speed

// global variable to handle the menu
volatile unsigned int menu_selection=0, menu_config=0, backlight_on=1, backlight_continuous=0, menu_modify=0;

// global variables for reading and debouncing the switches
static volatile unsigned int ct0=0, ct1=0, rpt=0, i=0;		// used for debouncing
volatile unsigned int key_press=0;		// key press detect
volatile unsigned int key_rpt=0;		// key long press and repeat
volatile unsigned int key_state=0;		// debounced and inverted key state:
										// bit = 1: key pressed
volatile unsigned int rpt_active=0;
volatile unsigned int rpt_state=0;									
																			
volatile unsigned int key_enter_short=0, key_plus_short=0, key_minus_short=0, key_esc_short=0;
volatile unsigned int key_enter_rpt=0, key_plus_rpt=0, key_minus_rpt=0, key_esc_rpt=0;

// global variables to store the output voltage and current
volatile unsigned int voltage_output=0, current_output=0, voltage_ac=0, temperature_plus_50=0;

// global variables to store the mains and the pfc voltage
volatile unsigned int voltage_mains=110, voltage_pfc=390;

// global variables to store the output power
volatile unsigned long output_power=0;

// global variables to store the input current
volatile unsigned long input_current=0;

// global variable for setting the reference voltage;
volatile unsigned int ref_voltage;

// global variable for setting the reference current;
volatile unsigned int ref_current;

// global variable containing the error current variable = current_output - ref_current;
static volatile unsigned int error_current;

// global variable containing the error voltage variable = voltage_output - ref_voltage;
static volatile signed int error_voltage;

// global variable for setting the PWM for the Fan (speed setting);
volatile unsigned long PWM_fan;

// global variables for setting the switching frequency
//volatile unsigned int threshold0_fswitch;

// global variable to store the state (OFF/stand-by/pre-charge/charging) of the power supply
volatile unsigned int status_supply=0;

// global variable to indicate that there is an alarm; alarm=0 -> no alarm
// bit0 => Mains UVLO, bit1 => Mains OVV, bit2 => Output overvoltage, bit3 => Output Shorted, bit4 => Overtemperature 1
// bit5 => Overtemperature 2, bit6 => Fan Failure, bit7 => DC/DC Failure
volatile unsigned int alarm=0;

// global variable to indicate that there is an warning; warning=0 -> no warning
// bit0 => Output Current Limit, bit1 => Output Power Limit, bit2 => Input Current Limit, bit3 => Low Battery Voltage
volatile unsigned int warning=0;

// global variable to store the state of the backlight
volatile unsigned int status_backlight=0;

// global variable to store the state of the "Battery charger enabled"
volatile unsigned int charge_enabled=0;

// Master/Slave configuration,	master_slave = 10 -> Only the master is present ("stand alone system");
// 								master_slave < 10 means: this charger is the master and there are (10 - master_slave) slaves (example: master_slave = 8 means: one master + 2 slaves);
// 								master_slaves > 10  means: this charger is a slave and its number is (master_slave - 10);
volatile unsigned int master_slave=10;

// global variable to store the state of the "Type of Battery, Lead Acid = 0, Gel = 1"
volatile unsigned int battery_type=0;

// global variable to store the state of the Trickle charge voltage level (default=26.6V for 12 elements)
volatile unsigned int trickle_voltage=5;

// global variable to store the state of the Float voltage level (default=28.8V for 12 element)
volatile unsigned int float_voltage=288;

// global variable to store the state of the Minimum charge voltage level (default=24V for 12 element)
volatile unsigned int minimum_voltage=240;

// global variable to store the state of the maximum output current
volatile unsigned int current_limit=60;

// global variable to store the state of the maximum output power (150 x 10 = 1500W), 10 Watt step
volatile unsigned int power_limit=150;

// global variable to store the state of the Minimum current to enter trickle charge
volatile unsigned int minimum_current_trickle=6;

// global variable to store the state of the Minimum mains AC voltage
volatile unsigned int mains_uvlo=185;

// global variable to store the state of the Maximum mains AC voltage
volatile unsigned int mains_ovv=265;

// global variable to store the state of compensation coefficient for Vout as function of battery temperature
volatile unsigned int temperature_coefficient=5;

// global variable to store the state of overtemperature protection
volatile unsigned int overtemperature_protection=60;

// global variable to store the state of backlight: 0=always OFF, 1=always ON, 2=timer
volatile unsigned int backlight=2;

volatile unsigned int maximum_current=60; // defines the maximum current of the converter
volatile unsigned int actual_current=0; // defines the actual current supplied by the converter

// global variable to store the state of the whole battery charger:
// 0=OFF
// 1=finished precharge PFC caps -> relay ON
// 2=PFC stage ON,
// 3=connect output terminals (precharge output caps)
// 4=output caps precharge completed, switch ON the Load FETs,
// 5=DC/DC ON, start ramping the output current,
// 6=DC/DC regulating the programmed current
volatile unsigned int status_charger=0;

static volatile unsigned int speed_state_up[6] = {6,100,6,6,200,1};	// defines the speed to go from STATE n to STATE n+1
// Defines the timing between states (from n to n+1) of the system
static volatile unsigned int speed_state_down[6] = {30,15,60,60,150,3}; // defines the speed to go from STATE n to STATE n-1
// Defines the timing between states (from n to n-1) of the system
static volatile unsigned int counter_max=300;	// defines the maximum number of counts for changing the state * 10msec, in this case 3 seconds
static volatile unsigned int counter_trickle=0;	// defines the maximum number of counts @ the trickle charging
static volatile unsigned long pwm_ref_current=0;	// variable for calculating the reference current and set the PWM duty cycle
//volatile unsigned int test=1;	// variable that puts the converter into test
static volatile unsigned int slave_current[9] = {0,0,0,0,0,0,0,0,0};
volatile unsigned Flag_PFC_Fail=0; // This is the FLAG set by undervoltage lockout of the 400V PFC output
volatile unsigned int Flag_String_Received=0; // This is the FLAG set when UART receives a string
volatile unsigned int char_number=0; // Actual number of character to be transmitted
volatile unsigned int Flag_Transmission_Done=0; // String sent = Flag transmission done = 1

volatile char receive_string[6] = {'x','x','x','x','x','x'};
volatile char string1[6] = {'#','y','y','y','y','y'};


void main(void)
{
	WDTCTL = WDTPW + WDTHOLD;	// stop watchdog

	
	// Delay of 1s to be sure that the supply voltage reached 3.45V.
	// The clock frequency can only be set to 16 MHz when the supply
	// voltage is high enough.
	// The initial clock frequency is 1 MHz. The delay-routine is made
	// for 16 MHz. So at 1 MHz 1/16 of the delay is only needed.
	// 1s @ 16 MHz = 62.5ms @ 1 MHz
	i_delay = 0;
	while(i_delay < 5000)
	{
		delay_us(12);				// results in 2ms @ 1 MHz
		i_delay++;
	}
	
	init_general();					// general initializations (clock module)
	init_fail_precharge();
	init_fb_enable();				// initialization of the Full Bridge (FB) enable output
	init_pfc_enable();				// initialization of the PFC Boost enable output
	init_precharge_relay();			// initialization of the PFC Boost precharge Relay output
	init_load_connect();			// initialization of the Load Connect output
	init_precharge_fets();			// initialization of the precharge FETs output
	init_backlight();				// initialization of LCD backlight
	init_uart();					// initialization of the UART
	init_green_led();				// initialization of LED
	init_yellow_led();				// initialization of LED
	init_red_led();					// initialization of LED
	init_switches();				// initialization of switches
	flash_restore_configuration();	// restore the saved presets from flash
	lcd_init(LCD_DISP_ON);			// initialization of the LCD
	init_adc();						// init AD converter and analog inputs
	init_timerB();					// initialization of Timer_B, main/bias sync
	init_timerA();					// initialization of Timer_A, reference voltage
	init_fan();						// initialization of Fan speed measurement pin
	init_pfc_pgd();					// initialization of the PFC UVLO pin
	_EINT();                  		  // enable interrupts (general)
	
//	TACCR1 = 10000;
	// A delay of at least 1s is needed to ensure a proper startup of the
	// PFC stage. During this time a message is shown.

	// Sets initial state of the backlight

	LED_green_off;
	LED_yellow_off;
	LED_red_off;
	TACCR1 = 16000;
	TBCCR1 = 16000;

	if(backlight == 0)
	{
		backlight_on = 0;	// reset flag
		BLIGHT_off;			// switch backlight off
	}
	else if (backlight == 1)
	{
		backlight_on = 1;	// set flag
		BLIGHT_on;			// switch backlight on
	}

	else if(backlight == 2)
	{
		counter_5s = 0;		// reset counter
		BLIGHT_on;			// switch backlight on
		backlight_on = 1;	// switch backlight on
	}

	LED_green_on;
	LED_yellow_on;
	LED_red_on;

	lcd_gotoxy(5,0); lcd_puts("TEXAS");
	lcd_gotoxy(2,1); lcd_puts("INSTRUMENTS");
	

	i_delay = 0;
	while(i_delay<150)		// 1.5s delay
	{
		delay_ms(5);
		i_delay++;
	}

	lcd_clrscr();
	lcd_gotoxy(0,0); lcd_puts("2KW Modular V1_3");
	lcd_gotoxy(0,1); lcd_puts("Battery Charger ");
	

	i_delay = 0;
	while(i_delay<150)		// 1.5s delay
	{
		delay_ms(10);
		i_delay++;
	}

	lcd_clrscr();
	LED_green_off;
	LED_yellow_off;
	LED_red_off;
  	// enable synchronization and reference voltage signal
//  	sync_main_on;
  	Fan_PWM_on;
	ref_voltage_on;
	ref_current_on;

	TBCCR1 = 0;

//	TACCR1 = 10000;
  	// enable AD conversion
   	set_bit(ADC10CTL0, ENC);
   	// start AD conversion     
   	set_bit(ADC10CTL0, ADC10SC);



   	for (;;)
	{

		if(flag_5s)	// used to switch the backlight off after 5s if set as "with timer"
		{
			flag_5s = 0;			// reset flag
			
			if( backlight_on && (backlight==2) )
			{
				backlight_on = 0;	// reset flag
				BLIGHT_off;			// switch backlight off
			}
		}
		
		
		// executed every 100ms
		if(flag_100ms)
		{
			flag_100ms = 0;			// reset flag
			
			counter_5s++;			// increment 1s variable
			if(counter_5s == 50)	// 1s passed
			{
				flag_5s = 1;		// set flag
				counter_5s = 0;		// reset counter
			}

			// read and convert the analog inputs
//			get_analog_inputs();
			
//////////////////////// Parameters Check //////////////////////////////////////////////////////////////////////

			if(master_slave<=10)					TACCR2 = 16000 - trickle_voltage*50;  // if in master configuration, the voltage loop decides Vout
			else								TACCR2 = 0;							  // in slave condition, Vout is set to maximum value
			
			PWM_fan = current_output;
			PWM_fan = PWM_fan * 415;
			PWM_fan = PWM_fan / maximum_current;
			PWM_fan = PWM_fan / 50;					// defines the gain of the FAN curve (already at full RPM when we reach half of the maximum current)
			if(PWM_fan <= 415)					TBCCR1 = PWM_fan;
			else								TBCCR1 = 415;


			if(TBCCR1<10)	TBCCR1 = 0;
//			if(status_charger == 0)
//				{
//				Fan_PWM_off;
//				}
//			else
//				{
//				Fan_PWM_on;
//				}

			if((warning > 0)||((status_charger>0) && (status_charger<6) && alarm==0)) LED_yellow_on;
			else LED_yellow_off;

			if(alarm > 0) LED_red_on;
			else LED_red_off;

			if(status_charger == 6) LED_green_on;
			else LED_green_off;

//////////////////////// End of Parameters Check ///////////////////////////////////////////////////////////////
						
			// read switches
			if(get_key_short(SWITCH_MODE))
			{
				key_enter_short = 1;
			}
//			else key_enter_short = 0;
			
			if(get_key_short(SWITCH_PLUS))
			{
				key_plus_short = 1;
			}
//			else key_plus_short = 0;
			
			if(get_key_short(SWITCH_MINUS))
			{
				key_minus_short = 1;				
				
			}
//			else key_minus_short = 0;

			if(get_key_short(SWITCH_ENABLE))
			{
				key_esc_short = 1;

			}
//			else key_esc_short = 0;


//			if(get_key_rpt(SWITCH_MODE)) key_enter_rpt = 1;
//			else key_enter_rpt = 0;
			
			if(get_key_rpt(SWITCH_PLUS)) key_plus_rpt = 1;
			else key_plus_rpt = 0;
			
			if(get_key_rpt(SWITCH_MINUS)) key_minus_rpt = 1;
			else key_minus_rpt = 0;

			if(get_key_rpt(SWITCH_ENABLE))
			{
				key_esc_rpt = 1;
				key_esc_short = 0;
			}
			else key_esc_rpt = 0;


			// If a switch is pressed, further 5 seconds will be added to the timeout of the backlight (if it is set as "with timer")
			if(( key_enter_short || key_plus_short || key_minus_short || key_esc_short ) && (backlight == 2))
			{
				counter_5s = 0;		// reset counter
				BLIGHT_on;			// switch backlight on
				backlight_on = 1;	// switch backlight on
			}

			// Set the backlight always ON or always OFF according to the "backlight" global set
			if((backlight == 0) && (backlight_on))
			{
				backlight_on = 0;	// reset flag
				BLIGHT_off;			// switch backlight off
			}
			else if ((backlight == 1) && (backlight_on==0))
			{
				backlight_on = 1;	// set flag
				BLIGHT_on;			// switch backlight on
			}
			
			if(menu_selection == 0)				// we are in the MAIN menu
			{
				if(key_enter_short)	menu_selection = 10; key_enter_short=0; // Select menu: SET
				if(key_plus_short)	menu_selection = 30; key_plus_short=0;// Select menu: READ
				if(key_minus_short)	menu_selection = 41; key_minus_short=0;// Select menu: ALARM
				if(key_esc_rpt && !alarm)
				{
					key_esc_rpt = 0;
					if(charge_enabled) charge_enabled = 0; // Enables ON or OFF the battery charger if there is no alarm present
					else charge_enabled = 1;
				}
			}

			if((menu_selection > 9) && (menu_selection < 23))						// we are in the SET menu
			{
				if(menu_modify)														// if menu_modify = 1, we are allowed to modify the parameters
				{
					if(key_enter_short)	menu_modify = 0; key_enter_short = 0;								// parameter modification
					switch(menu_selection)
					{
					case 10:
						if(key_minus_short && (master_slave > 1))	master_slave--; key_minus_short = 0;			// decrease parameter
						if(key_plus_short && (master_slave < 19))	master_slave++; key_plus_short = 0;		// increase parameter
					break;

					case 11:
						if(key_minus_short && (battery_type > 0))	battery_type--; key_minus_short = 0;			// decrease parameter
						if(key_plus_short && (battery_type < 1))	battery_type++; key_plus_short = 0;	 		// increase parameter
					break;

					case 12:
						if((key_minus_short && (trickle_voltage > 0)) || (key_minus_rpt) && (trickle_voltage > 10))
						{
							if(key_minus_rpt)		trickle_voltage = trickle_voltage - 9;
							key_minus_short = 0;
							trickle_voltage--; 		// decrease parameter
						}
						if((key_plus_short && (trickle_voltage < 315)) || (key_plus_rpt) && (trickle_voltage < 300)) // erano 275 e 265
						{
							if(key_plus_rpt)		trickle_voltage = trickle_voltage + 9;
							trickle_voltage++;
							key_plus_short = 0;	 		// increase parameter
						}
					break;

					case 13:
						if(key_minus_short && (float_voltage > 279))	float_voltage--; key_minus_short = 0;		// decrease parameter
						if(key_plus_short && (float_voltage < 297))	float_voltage++; key_plus_short = 0;	 			// increase parameter
					break;

					case 14:
						if(key_minus_short && (minimum_voltage > 233))	minimum_voltage--; key_minus_short = 0;		// decrease parameter
						if(key_plus_short && (minimum_voltage < 247))	minimum_voltage++; key_plus_short = 0;	 		// increase parameter
					break;

					case 15:
						if(key_minus_short && (current_limit > 0))		current_limit--; key_minus_short = 0;		// decrease parameter
						if(key_plus_short && (current_limit < maximum_current))		current_limit++; key_plus_short = 0;	 		// increase parameter
					break;

					case 16:
						if(key_minus_short && (power_limit > 100))	power_limit--; key_minus_short = 0;				// decrease parameter
						if(key_plus_short && (power_limit < 150))	power_limit++; key_plus_short = 0;	 				// increase parameter
					break;

					case 17:
						if(key_minus_short && (minimum_current_trickle > 2))	minimum_current_trickle--; key_minus_short = 0;	// decrease parameter
						if(key_plus_short && (minimum_current_trickle < 20))	minimum_current_trickle++; key_plus_short = 0;	 		// increase parameter
					break;

					case 18:
						if(key_minus_short && (mains_uvlo > 80))	mains_uvlo--; key_minus_short = 0;				// decrease parameter
						if(key_plus_short && (mains_uvlo < 200))	mains_uvlo++; key_plus_short = 0;	 				// increase parameter
					break;

					case 19:
						if(key_minus_short && (mains_ovv > 240))	mains_ovv--; key_minus_short = 0;				// decrease parameter
						if(key_plus_short && (mains_ovv < 275))		mains_ovv++; key_plus_short = 0;	 				// increase parameter
					break;

					case 20:
						if(key_minus_short && (temperature_coefficient > 0))	temperature_coefficient--; key_minus_short = 0;		// decrease parameter
						if(key_plus_short && (temperature_coefficient < 10))	temperature_coefficient++; key_plus_short = 0;	 		// increase parameter
					break;

					case 21:
						if(key_minus_short && (overtemperature_protection > 45))	overtemperature_protection--; key_minus_short = 0;		// decrease parameter
						if(key_plus_short && (overtemperature_protection < 80))		overtemperature_protection++; key_plus_short = 0;	 		// increase parameter
					break;

					case 22:
						if(key_minus_short && (backlight > 0))	backlight--; key_minus_short = 0;		// decrease parameter
						if(key_plus_short && (backlight < 2))	backlight++; key_plus_short = 0;	 		// increase parameter
					break;

					} // end switch menu selection

					if(key_esc_short)	menu_modify = 0; key_esc_short = 0;			// exit parameter modification

				}
				else
				{
					if(key_enter_short)	menu_modify = 1; key_enter_short = 0;								// parameter modification
					if(key_minus_short && (menu_selection > 10))	menu_selection--; key_minus_short = 0;	// select the previous menu
					if(key_plus_short && (menu_selection < 22))		menu_selection++; key_plus_short = 0;	// Select the next menu
					if(key_esc_short)
					{
						menu_selection = 23; // show "configuration SAVED"
						key_esc_short = 0;
					}
				}
			}	// end of menu SET

			if((menu_selection==23)&&(key_esc_short ))
			{
				key_esc_short = 0;
				menu_selection = 0;														//select main menu
				flash_save_configuration();												//save modified configuration
			}
			if((menu_selection > 29) && (menu_selection < 40))							// we are in the READ menu
			{
				if(key_minus_short && (menu_selection > 30))	menu_selection--; key_minus_short = 0;	// select the previous menu
				if(key_plus_short && (menu_selection < 32))		menu_selection++; key_plus_short = 0;	// Select the next menu
				if(key_esc_short) 								menu_selection = 0; key_esc_short = 0;	// select MAIN menu
				if(key_enter_short)								key_enter_short = 0;					// if "enter" is pressed, do nothing
			}

			if((menu_selection > 39) && (menu_selection < 52))							// we are in the ALARM menu
			{
				if((alarm==0)&&(warning==0))
				{
					menu_selection = 40;	// if there is no alarm nor warning, remain in the "no alarm, no warning" display
				}
				else
				{
//					if(key_minus_short && (menu_selection > 41))			menu_selection--;		// select the previous alarm (if existing)
					if(key_plus_short && (menu_selection < 51))				menu_selection++; key_plus_short = 0; 		// Select the next alarm (if existing)

					if((menu_selection == 41) && (alarm & BIT0)!=BIT0)		menu_selection++;	// stays in the actual alarm (if existing), otherwise skip it and go to next
					if((menu_selection == 42) && (alarm & BIT1)!=BIT1)		menu_selection++;	// stays in the actual alarm (if existing), otherwise skip it and go to next
					if((menu_selection == 43) && (alarm & BIT2)!=BIT2)		menu_selection++;	// stays in the actual alarm (if existing), otherwise skip it and go to next
					if((menu_selection == 44) && (alarm & BIT3)!=BIT3)		menu_selection++;	// stays in the actual alarm (if existing), otherwise skip it and go to next
					if((menu_selection == 45) && (alarm & BIT4)!=BIT4)		menu_selection++;	// stays in the actual alarm (if existing), otherwise skip it and go to next
					if((menu_selection == 46) && (alarm & BIT5)!=BIT5)		menu_selection++;	// stays in the actual alarm (if existing), otherwise skip it and go to next
					if((menu_selection == 47) && (alarm & BIT6)!=BIT6)		menu_selection++;	// stays in the actual alarm (if existing), otherwise go back to the first alarm

					if((menu_selection == 48) && (warning & BIT0)!=BIT0)	menu_selection++;	// stays in the actual warning (if existing), otherwise skip it and go to next
					if((menu_selection == 49) && (warning & BIT1)!=BIT1)	menu_selection++;	// stays in the actual warning (if existing), otherwise skip it and go to next
					if((menu_selection == 50) && (warning & BIT2)!=BIT2)	menu_selection++;	// stays in the actual warning (if existing), otherwise skip it and go to next
					if((menu_selection == 51) && (warning & BIT3)!=BIT3)	menu_selection=41;	// stays in the actual warning (if existing), otherwise go back to the first warning
				}
				if(key_enter_short&&(menu_selection<48))
				{
					menu_selection = 41; key_enter_short = 0;
					alarm = 0;					//reset all alarms
				}
				if(key_esc_short) menu_selection = 0; key_esc_short = 0;								// select MAIN menu
			}
			counter_500ms++;
			if(counter_500ms>5)
			{
				counter_500ms=0;
				show_info(menu_selection);		// show menu
			}
		}	// flag_100ms
		
		
		
		// executed every 50ms
		if(flag_50ms)
		{
//			IE2 |= UCA0TXIE; // enable TX interrupt
			flag_50ms = 0;	// reset flag
			if(master_slave<10)								// if master_slave < 10 this converter is a master
			{
				if (number_of_slave<(10-master_slave))		number_of_slave++;
				else 										number_of_slave = 1;
				string1[1] = 'M';
				string1[2] = (48 + number_of_slave);
				if (charge_enabled)							string1[3] = 'E';
				else										string1[3] = 'D';
				string1[4] = 48 + current_output / 1000;
				string1[5] = 48 + (current_output - (string1[4] - 48) * 1000) / 100;
				if(Flag_Transmission_Done == 1)			IE2 |= UCA0TXIE;		// enables the TX interrupt (if the previous transmission was finished), which will send the STRING1 through CAN interface
			}

		}	// flag_50ms

		if(flag_1ms)
		{
			flag_1ms = 0;	// reset flag
			counter_1ms++;			// increment 1ms variable
			if(counter_1ms == 10)	// 10ms passed
			{
				flag_10ms = 1;		// set flag
				counter_1ms = 0;	// reset counter
			}

			if (((PFC_PGD&BIT1)==BIT1)&(status_charger>=5)&(Flag_PFC_Fail==0))
			{
				Flag_PFC_Fail = 1;
				Full_bridge_off;
				status_charger=4;
				counter_status=0;
			}

		}

		// executed every 10ms, used for reading and debouncing the switches
		if(flag_10ms)
		{
			flag_10ms = 0;			// reset flag
			counter_50ms++;			// increment 50ms variable
			counter_10ms++;			// increment 10ms variable

			if(counter_50ms == 5)	// 50ms passed
			{
				flag_50ms = 1;		// set flag
				counter_50ms = 0;	// reset counter
			}

			if(counter_10ms == 10)	// 100ms passed
			{
				flag_100ms = 1;		// set flag
				counter_10ms = 0;	// reset counter
			}

			if (Flag_String_Received == 1)
			{
				Flag_String_Received = 0;
				if ((receive_string[1] == 'M')&&(receive_string[2] == (master_slave + 38)))		// process the command only if the # of Slave matches
				{
					if ((receive_string[3] == 'E')&&(alarm == 0))						charge_enabled = 1;	// switch the charger ON if there is no alarm
					if (receive_string[3] == 'D')										charge_enabled = 0;
					if ((receive_string[4] < 58)&&(receive_string[4] > 47)&&(receive_string[5] < 58)&&(receive_string[5] > 47))
					{
						current_limit = 10 * (receive_string[4] - 48);
						current_limit = current_limit + receive_string[5] - 48;
						string1[1] = 'S';
						string1[2] = (master_slave + 38);
						string1[3] = 48 + current_output / 1000;
						string1[4] = 48 + (current_output - (string1[3] - 48) * 1000) / 100;
						string1[5] = 48 + (current_output - (string1[4] - 48) * 100 - (string1[3] - 48) * 1000) / 10;
						if(Flag_Transmission_Done == 1)			IE2 |= UCA0TXIE;		// enables the TX interrupt (if the previous transmission was finished), which will send the STRING1 through CAN interface
					}
				}
			}


			i = key_state ^ SWITCH_PIN;			// key changed?

			i = i & BIT_MASK;					// throw away other bits
			key_state = key_state & BIT_MASK;	// throw away other bits

			ct0 = ~( ct0 & i );				// reset or count ct0
			ct0 = ct0 & BIT_MASK;			// throw away other bits
			ct1 = ct0 ^ (ct1 & i);			// reset or count ct1
			ct1 = ct1 & BIT_MASK;			// throw away other bits
			i &= ct0 & ct1;					// count until roll over ?
			key_state ^= i;					// then toggle debounced state
			key_press |= key_state & i;		// 1->0: key press detect

			if( (key_state != BIT_MASK)	&& !(rpt_active))	// check repeat function
			{
				rpt_state = ~key_state;						// save key status
				rpt_state = rpt_state & BIT_MASK;			// throw away other bits
				rpt = REPEAT_START;							// start delay
				rpt_active = 1;
			}

			if(rpt_active) rpt--;

			if( (rpt == 0) && rpt_active)
			{
				key_rpt = rpt_state & (~key_state);			// check if the key is still pressed
				key_rpt = key_rpt & BIT_MASK;				// throw away other bits
				rpt_active = 0;								// reset flag
			}

			get_analog_inputs();

			check_status();

//	Section that increases / decreases the "state" of the converter going from 0 (OFF) to 6 (regulating)
			if((alarm > 0) && (charge_enabled == 1)) charge_enabled = 0;	// if there is an alarm, switch OFF the system

			counter_trickle = minimum_current_trickle * counter_max;
			counter_trickle = counter_trickle / maximum_current;
//		pwm_ref_current is the PWM of the current limit loop
// 		counter_status = a variable proportional to the actual current limit (ramping up or down); maximum value = counter_max
//		counter_status ramps up to a maximum value of counter_max (=300); since we want a ref_current (for example)= 3655 equivalent to 36.55A, we divide not by 300 (counter_max) but by 3
//			if(status_charger > 4)
//			{
//				ref_current = current_limit * counter_status;
//				ref_current = ref_current / 3;
//			}
//			else ref_current = 0;

			if(status_charger > 4)
			{
				pwm_ref_current = counter_status;
				pwm_ref_current = pwm_ref_current * 16000;
				pwm_ref_current = pwm_ref_current / counter_max;
				pwm_ref_current = pwm_ref_current * current_limit;
				pwm_ref_current = pwm_ref_current / maximum_current;
			}
			else pwm_ref_current = 0;


			if(pwm_ref_current < 16000)
			{
			TACCR1 = 16000 - pwm_ref_current;
			}
			else TACCR1 = 0;
			
			if(charge_enabled == 1)
			{
				if(status_charger < 6)
				{
					if((status_charger == 5)&&(voltage_output < 1000)&&(counter_status >= counter_trickle)&&(test==0))
					{
						counter_status = counter_trickle;
					}
					else
					{
						counter_status = counter_status + speed_state_up[status_charger];
					}
					if(counter_status  >= counter_max)
					{
						if(status_charger < 5)				counter_status = 0;
						if(status_charger == 3)
						{
							if(((FAIL_PRECHARGE&BIT3)==BIT3)&&(test==0))			// check on precharge voltage fail pin
							{
								alarm =  alarm | BIT6;		// Set alarm DC/DC failure
								charge_enabled = 0;			// Switch OFF the charger
							}
						}
						if(Flag_PFC_Fail == 1)
						{
							if(((~PFC_PGD)&BIT1)==BIT1)
								{
								Flag_PFC_Fail=0;
								}
						}
						else
						{
							status_charger++;
						}
					}
				}
			}				//Charger disabled or alarm present
			else
			{
				Flag_PFC_Fail = 0;
				if(status_charger > 0)
				{
					counter_status = counter_status - speed_state_down[status_charger];
					if(counter_status < 0)			counter_status =0;
					if(counter_status  == 0)
					{
						status_charger--;
						counter_status = counter_max;
					}
				}
			}

			switch(status_charger) // Define each output according to the state of the converter
			{
				case 0:
					Precharge_relay_off; PFC_off; Disconnect_load; Precharge_fb_off; Full_bridge_off;
				break;

				case 1:
					Precharge_relay_on; PFC_off; Disconnect_load; Precharge_fb_off; Full_bridge_off;
				break;

				case 2:
					Precharge_relay_on; PFC_on; Disconnect_load; Precharge_fb_off; Full_bridge_off;
				break;

				case 3:
					Precharge_relay_on; PFC_on; Connect_load; Precharge_fb_off; Full_bridge_off;
				break;

				case 4:
					Precharge_relay_on; PFC_on; Connect_load; Precharge_fb_on; Full_bridge_off;
				break;

				case 5:
					Precharge_relay_on; PFC_on; Connect_load; Precharge_fb_on; Full_bridge_on;
				break;

			}

		}	// flag_10ms
			
	}	// for
	
}	// main
